#import <Foundation/Foundation.h>


@interface MCChannel: NSObject <NSCoding>
{
    NSMutableDictionary *channels;
}

+ (void)loggingOn;
+ (void)loggingOff;
+ (BOOL)isLoggingOn;

- (void)dealloc;

- (NSMutableDictionary *)channels;
- (id)addChannel:aChannel withName:(NSString *)aName;

- (id)perform:(SEL)aSel onChannelNamed:(NSString *)aName;
- (id)perform:(SEL)aSel with:(id)arg1 onChannelNamed:(NSString *)aName;
- (id)perform:(SEL)aSel with:(id)arg1 with:(id)arg2 onChannelNamed:(NSString *)aName;

- (id)findChannelNamed:(NSString *)aName;
- (id)findChannelNamed:(NSString *)aName checkSelector:(SEL)aSel;

- (id)hitTargets:sender;


// TYPED STREAM SUPPORT

- (id)initWithCoder:(NSCoder *)coder;
- (void)encodeWithCoder:(NSCoder *)aCoder;

@end



